module:    Test-Utilities-Implementation
author:    Matthias Hlzl (tc@gauss.muc.de)
copyright: Copyright (C) 1996, 1997, 1998 Matthias Hlzl
           Copyright (C) 1998 Way Forward Technologies
version:   0.03 09 Dec 1998
synopsis:  The driver for the test-utilities test-suite.

// Copyright.
// =========

// The driver for the test-utilities test-suite.
// Copyright (C) 1998 Matthias Hlzl.
// Copyright (C) 1998 Way Forward Technologies.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston,
// MA 02111-1307  USA
//
// If you need to receive this program under another license contact
// the author (tc@gauss.muc.de).

define method main 
    (name :: <byte-string>, #rest switches)
 => ();
  if (member?("--test-primitives", switches, test: \=)
	| member?("-p", switches, test: \=))
    run-one-iteration();
    silent-tests(#t);
    run-one-iteration();
    verbose-tests(#t);
    run-one-iteration();
    gabby-tests(#t);
    run-one-iteration();
  end if;

  say-newline();
  run-testcase();
  silent-tests(#t);
  run-testcase();
end method main;

define function run-one-iteration () => ();
  test-say-line();
  test-say();
  test-maybe-say();
  test-dont-say();
end function run-one-iteration;

define function test-say-line () => ();
  say-line("This is a line of text printed with say-line().");
  say-line("This is another line of text printed with say-line().");
  say-newline();
end function test-say-line;

define function test-say () => ();
  say("Testing say()\n");
  say("=============\n\n");
  say("This is a test of say().\n");
  say("The %= of %= is %=\n", "value", #"i", 123);
  say("You can include escapes like %=.\n");
  say("There is ");
  say("no implicit ");
  say("linefeed.\n");
  say-newline();
end function test-say;

define function test-maybe-say () => ();
  maybe-say("Testing maybe-say()\n");
  maybe-say("===================\n\n");
  maybe-say("This is a test of maybe-say().\n");
  maybe-say("The %= of %= is %=\n", "value", #"i", 123);
  maybe-say("You can include escapes like %=.\n");
  maybe-say("There is ");
  maybe-say("no implicit ");
  maybe-say("linefeed.\n");
  maybe-say-newline();
end function test-maybe-say;

define function test-dont-say () => ();
  dont-say("Testing dont-say()\n");
  dont-say("==================\n\n");
  dont-say("This is a test of dont-say().\n");
  dont-say("The %= of %= is %=\n", "value", #"i", 123);
  dont-say("You can include escapes like %=.\n");
  dont-say("There is ");
  dont-say("no implicit ");
  dont-say("linefeed.\n");
  dont-say-newline();
end function test-dont-say;

define function run-testcase () => ();
  announce-section("This is the first section");
  announce("First test");
  say-done();
  announce("Second test fails");
  report-error("The second test failed");
  say-done();
  say-intermediate-results();

  announce-section("This is the second section");
  announce("First test");
  say-done();
  announce("Second test");
  say-done();
  say-intermediate-results();

  announce-section("This is the third section");
  announce("First test fails");
  report-error();
  say-done();
  announce("Second test fails");
  report-error("i is %=, should be %=", 1, 0);
  say-done();
  say-intermediate-results();

  say-results();
end function run-testcase;