module:    dylan-user
author:    Matthias Hlzl (tc@gauss.muc.de)
copyright: Copyright (C) 1996, 1998 Matthias Hlzl
           Copyright (C) 1998 Way Forward Technologies
version:   0.03 09 Dec 1998
synopsis:  This Library is intended to implement various utilities
           useful for most programs.  Currently only a module to
           simplify the printing of test results is implemented.

define library Utilities
  use Dylan;
  use Collection-Extensions;
  use String-Extensions;
  use Print;
  use Streams;
  use Standard-IO;
  use Format;
  export Test-Utilities;
end library Utilities;

define module Test-Utilities
  create silent-tests, verbose-tests, gabby-tests;
  create say-newline, maybe-say-newline, dont-say-newline;
  create say-line;
  create say, maybe-say, dont-say;
  create announce-section, announce;
  create report-error;
  create say-done, say-intermediate-results, say-results;
end module Test-Utilities;

define module Test-Utilities-Implementation
  use Dylan;
  use Extensions;		// from Dylan
  use Subseq;			// from Collection-Extensions
  use Character-Type;		// from String-Extensions
  use String-Hacking;		// from String-Extensions
  use Streams;
  use Standard-IO;
  use Format;
  use Test-Utilities;
end module Test-Utilities-Implementation;
